/*
 * Decompiled with CFR 0.152.
 */
package requesterpj.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import requesterpj.internal.config.RequesterConfig;
import requesterpj.internal.connection.RequesterConnection;
import requesterpj.internal.metadata.HttpRequesterOutputResolver;
import requesterpj.internal.metadata.ValuesParameterHttpRequesterOperation;

public class HttpRequesterOperation
extends BaseRestOperation {
    private static final String APPLICATION_JSON = "application/json";

    @MediaType(value="application/json")
    @OutputResolver(output=HttpRequesterOutputResolver.class)
    public void getHttp(@Config RequesterConfig config, @Connection RequesterConnection connection, CompletionCallback<InputStream, Object> callback, String endpoint, @Content(primary=true) @TypeResolver(value=ValuesParameterHttpRequesterOperation.class) TypedValue<InputStream> values) {
        String fullUri = connection.getBaseUri() + "/" + endpoint;
        HttpRequest build = HttpRequest.builder().uri(fullUri).method(HttpConstants.Method.GET).build();
        CompletableFuture httpResponseCompletableFuture = connection.getHttpClient().sendAsync(build, HttpRequestOptions.builder().followsRedirect(true).build());
        httpResponseCompletableFuture.whenComplete((response, exception) -> {
            if (exception != null) {
                callback.error(exception);
            } else if (response.getStatusCode() > 300 || response.getStatusCode() < 200) {
                callback.error((Throwable)new Exception("Invalid status code: " + response.getStatusCode()));
            } else {
                Result result = Result.builder().output((Object)response.getEntity().getContent()).build();
                callback.success(result);
            }
        });
    }
}

