/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package requesterpj.internal.connection.provider;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import requesterpj.internal.connection.RequesterConnection;

public class RequesterConnectionProvider extends RestConnectionProvider<RequesterConnection> {

    @DisplayName("Base Uri")
    @Summary("Parameter base URI. Each instance or tenant gets its own base URI.")
    @Parameter
    @Optional
    private String baseUri;

    @Override public String getBaseUri() {
        return baseUri;
    }

    @Override
    protected RequesterConnection createConnection(HttpClient httpClient) {
        return new RequesterConnection(httpClient, getBaseUri());
    }

    @Override
    public ConnectionValidationResult validate(RequesterConnection connection) {
        String fullUri = connection.getBaseUri();

        HttpRequest build = HttpRequest.builder()
            .uri(fullUri)
            .method(HttpConstants.Method.GET)
            .build();

        try {
            int statusCode =  connection.getHttpClient().send(build).getStatusCode();

            if (statusCode > 300 || statusCode < 200) {
                return ConnectionValidationResult.failure("Invalid status code: " + statusCode,
                                                          new Exception("Invalid status code: " + statusCode));
            } else {
                return ConnectionValidationResult.success();
            }
        } catch (Exception e) {
            return ConnectionValidationResult.failure(e.getMessage(),new Exception("Unexpected error has occurred"));
        }
    }

}
