/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package requesterpj.internal.operation;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;

import java.io.InputStream;
import java.util.concurrent.CompletableFuture;

import requesterpj.internal.config.RequesterConfig;
import requesterpj.internal.connection.RequesterConnection;
import requesterpj.internal.metadata.HttpRequestXmlOutputResolver;
import requesterpj.internal.metadata.ValuesParameterHttpRequesterXmlOperation;

public class HttpRequestXmlOperation extends BaseRestOperation {

    private static final String APPLICATION_XML = "application/xml";

    @MediaType(APPLICATION_XML)
    @OutputResolver(
        output = HttpRequestXmlOutputResolver.class)
    public void getHttpXml(
            @Config RequesterConfig config, //TODO do we want a config here?
            @Connection RequesterConnection connection,
            CompletionCallback<InputStream, Object> callback,
            String endpoint,
            @Content(primary = true)
            @TypeResolver(ValuesParameterHttpRequesterXmlOperation.class)
                TypedValue<InputStream> valuesXml) {

        String fullUri = connection.getBaseUri() + "/" + endpoint;

        HttpRequest build = HttpRequest.builder()
            .uri(fullUri)
            .method(HttpConstants.Method.GET)
            .build();

        CompletableFuture<HttpResponse> httpResponseCompletableFuture =
            connection.getHttpClient().sendAsync(build, HttpRequestOptions.builder().followsRedirect(true).build());

        httpResponseCompletableFuture.whenComplete(
            (response, exception) -> {
                if (exception != null) {
                    callback.error(exception);
                } else if (response.getStatusCode() > 300 || response.getStatusCode() < 200) {
                    callback
                        .error(new Exception("Invalid status code: " + response.getStatusCode()));
                } else {
                    Result<InputStream, Object> result = Result
                        .<InputStream, Object>builder()
                        .output(response.getEntity().getContent())
                        .build();
                    callback.success(result);
                }
            });
    }
}
