/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package requesterpj.internal.operation;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;

import java.io.InputStream;

import requesterpj.internal.config.RequesterConfig;
import requesterpj.internal.connection.RequesterConnection;
import requesterpj.internal.metadata.HttpRequestXmlOutputResolver;
import requesterpj.internal.metadata.ValuesParameterHttpRequesterXmlOperation;

public class HttpRequestXmlOperation extends BaseRestOperation {

    private static final String APPLICATION_XML = "application/xml";

    @MediaType(APPLICATION_XML)
    @OutputResolver(
        output = HttpRequestXmlOutputResolver.class)
    @Throws(RestErrorTypeProvider.class)
    public void getHttpXml(
            @Connection RequesterConnection connection,
            CompletionCallback<InputStream, Object> callback,
            String endpoint,
            @Content(primary = true)
            @TypeResolver(ValuesParameterHttpRequesterXmlOperation.class)
            TypedValue<InputStream> valuesXml) {
        try {
            connection.sendAsync(HttpRequest.builder()
                                     .uri(connection.getBaseUri() + "/" + endpoint)
                                     .method(HttpConstants.Method.GET)
                                     .build())
                .thenApply(throwModuleExceptionIfErrorResponse())
                .thenAccept(httpResponse -> callback.success(Result
                    .<InputStream, Object>builder()
                    .output(httpResponse.getEntity().getContent())
                    .build()))
                .exceptionally(notifyCompletionCallbackError(callback));
        } catch (Throwable t) {
            callback.error(t);
        }
    }
}
