/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package requesterpj.server;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.BodyHandler;
import io.vertx.ext.web.handler.LoggerHandler;
import requesterpj.server.connection.TestConnection;
import requesterpj.server.operation.HttpGet;
import requesterpj.server.operation.HttpGetFailure;

public class HttpRequesterConnectorMockService extends AbstractVerticle {

  private final Vertx vertx = Vertx.vertx();
  private final Integer port;

  public HttpRequesterConnectorMockService(Integer port) {
    this.port = port;
  }

  public void stopServer() {
    vertx.close();
  }

  @Override
  public void start() {
    Router router = Router.router(vertx);

    router
        .route()
        .handler(LoggerHandler.create())
        .handler(BodyHandler.create())
        .blockingHandler(BodyHandler.create());

    router.get("/TestRequest").blockingHandler(new HttpGet());
    router.get("/TestConnection").blockingHandler(new TestConnection());
    router.get("/TestRequestFailure").blockingHandler(new HttpGetFailure());

    vertx.createHttpServer()
        .requestHandler(router)
        .listen(port, result -> {
          if (!result.succeeded()) {
            result.cause().printStackTrace();
          }
        });
  }

}
