/*
 * (c) 2003-2022 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package requesterpj.internal.operation;

import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.connectivity.rest.commons.api.config.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.internal.util.AutoCloseableCursorProviderInputStream;
import com.mulesoft.connectivity.rest.commons.internal.util.FileUtils;

import java.io.InputStream;

import requesterpj.internal.connection.RequesterConnection;

public class HttpRequestTransformedOutputOperation extends BaseRestOperation {

    private static final String APPLICATION_JSON = "application/json";

    @MediaType(APPLICATION_JSON)
    @Throws(RestErrorTypeProvider.class)
    public void getHttpTransformedOutput(
            @Config RestConfiguration configuration,
            @Connection RequesterConnection connection,
            CompletionCallback<InputStream, Object> callback,
            String endpoint) {
        try {
            connection.sendAsync(HttpRequest.builder()
                                     .uri(connection.getBaseUri() + "/" + endpoint)
                                     .method(HttpConstants.Method.GET)
                                     .build(),
                                 resolveDefaultResponseMediaType(configuration))
                .thenAccept(result -> {
                    TypedValue<?> typedValue = getExpressionLanguage()
                        .evaluate(
                            FileUtils.readFile(getClass().getClassLoader(), "requesterpj/HttpRequestTransformedOutput.dwl"),
                            BindingContext.builder()
                                .addBinding("payload",
                                            new TypedValue(result.getEntityContent(),
                                                           DataType.builder().mediaType(result.getMediaType()).build()))
                                .build());
                    CursorStreamProvider value = (CursorStreamProvider) typedValue.getValue();

                    callback.success(Result.<InputStream, Object>builder()
                                         .output(new AutoCloseableCursorProviderInputStream(value))
                                         .mediaType(typedValue.getDataType().getMediaType())
                                         .build());
                })
                .exceptionally(notifyCompletionCallbackError(callback));
        } catch (Throwable t) {
            callback.error(t);
        }
    }

}
