/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.mule.testing.processing.strategies.test.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BarrierProvider {

    private final Map<String, Barrier> barrierMap = new ConcurrentHashMap<>();

    public Barrier get(String name) {
        return barrierMap.computeIfAbsent(name, n -> new Barrier());
    }

    public static class Barrier {

        private boolean isReleased = false;
        private int blockedThreads = 0;

        public synchronized void block() throws InterruptedException {
            blockedThreads += 1;
            while (!isReleased) {
                wait();
            }
        }

        public synchronized void release() {
            isReleased = true;
            notifyAll();
        }

        public synchronized int blockedThreads() {
            return blockedThreads;
        }
    }
}
