/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mule.testing.processing.strategies.test.internal;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.mule.extension.mule.testing.processing.strategies.test.api.ExecutionThreadTracker;
import org.mule.extension.mule.testing.processing.strategies.test.internal.CompleterTask;
import org.mule.extension.mule.testing.processing.strategies.test.internal.CompletionCallbacksDeferrer;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;

public class MuleTestingProcessingStrategiesTestConnectionProvider
implements PoolingConnectionProvider<CompletionCallbacksDeferrer>,
Lifecycle {
    private final AtomicBoolean isStopped = new AtomicBoolean(false);
    private ScheduledExecutorService executorService;
    private BlockingQueue<CompleterTask> callbacksQueue;
    private Future<?> allCallbacksCompleted;
    @Inject
    private SchedulerService schedulerService;
    @Inject
    private ExecutionThreadTracker executionThreadTracker;

    public CompletionCallbacksDeferrer connect() throws ConnectionException {
        return new CompletionCallbacksDeferrer(this.callbacksQueue);
    }

    public void disconnect(CompletionCallbacksDeferrer connection) {
    }

    public ConnectionValidationResult validate(CompletionCallbacksDeferrer connection) {
        return ConnectionValidationResult.success();
    }

    public void initialise() throws InitialisationException {
        this.callbacksQueue = new ArrayBlockingQueue<CompleterTask>(10);
        this.executorService = this.schedulerService.customScheduler(SchedulerConfig.config().withName("Deferred callbacks completion thread").withMaxConcurrentTasks(1));
    }

    public void dispose() {
        this.executorService.shutdown();
    }

    public void start() throws MuleException {
        this.allCallbacksCompleted = this.executorService.submit(this::completeCallbacks);
        this.isStopped.set(false);
    }

    private void completeCallbacks() {
        try {
            while (!this.isStopped.get()) {
                CompleterTask completerTask = this.callbacksQueue.poll(500L, TimeUnit.MILLISECONDS);
                if (completerTask == null) continue;
                completerTask.complete(this.executionThreadTracker);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void stop() throws MuleException {
        try {
            this.isStopped.set(true);
            this.allCallbacksCompleted.get();
        }
        catch (ExecutionException e) {
            throw new LifecycleException((Throwable)e, (Object)this);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

