/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.mule.testing.processing.strategies.test.api;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BarrierProvider {
    private final Map<String, Barrier> barrierMap = new ConcurrentHashMap<String, Barrier>();

    public Barrier get(String name) {
        return this.barrierMap.computeIfAbsent(name, n -> new Barrier());
    }

    public static class Barrier {
        private boolean isReleased = false;
        private int blockedThreads = 0;

        public synchronized void block() throws InterruptedException {
            ++this.blockedThreads;
            while (!this.isReleased) {
                this.wait();
            }
        }

        public synchronized void release() {
            this.isReleased = true;
            this.notifyAll();
        }

        public synchronized int blockedThreads() {
            return this.blockedThreads;
        }
    }
}

