/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cookBook.internal.connection.provider;

import com.mulesoft.connectivity.rest.commons.api.connection.oauth.BaseClientCredentialsConnectionProvider;
import com.mulesoft.connectivity.rest.commons.api.connection.oauth.OAuthRestConnection;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.ClientCredentials;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

@Alias(value="oauth-client-credentials")
@ClientCredentials(tokenUrl="http://localhost:${freePortFound}/access-token", defaultScopes="READ")
public class CookBookOauthClientCredentialsConnectionProvider
extends BaseClientCredentialsConnectionProvider<OAuthRestConnection<OAuthState>> {
    @DisplayName(value="Base Uri")
    @Summary(value="Parameter base URI. Each instance or tenant gets its own base URI.")
    @Parameter
    @Optional
    private String baseUri;

    public String getBaseUri() {
        return this.baseUri;
    }

    public ConnectionValidationResult validate(OAuthRestConnection<OAuthState> restConnection) {
        return restConnection.validate(HttpRequest.builder().uri(restConnection.getBaseUri() + "/health").method(HttpConstants.Method.GET).build(), httpResponse -> {
            int statusCode = httpResponse.getStatusCode();
            if (statusCode > 300 || statusCode < 200) {
                return ConnectionValidationResult.failure((String)("Invalid status code: " + statusCode), (Exception)new Exception("Invalid status code: " + statusCode));
            }
            return ConnectionValidationResult.success();
        }, exception -> ConnectionValidationResult.failure((String)"There was an error while testing the connection", (Exception)exception));
    }
}

