/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cookBook.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectors.cookBook.internal.metadata.CategoryParameterAddInvalidCategoryOperationInputResolver;
import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;

public class AddInvalidCategoryOperation
extends BaseRestOperation {
    protected Function<HttpResponse, Optional<ErrorTypeDefinition<? extends Enum<?>>>> httpResponseToErrorTypeDefinition() {
        return httpResponse -> {
            if (httpResponse.getStatusCode() >= 200 && httpResponse.getStatusCode() < 300) {
                Boolean isResponseWithError = (Boolean)this.getExpressionLanguage().evaluate("#[payload.error]", DataType.fromType(Boolean.class), BindingContext.builder().addBinding("payload", new TypedValue((Object)httpResponse.getEntity().getContent(), DataType.JSON_STRING)).build()).getValue();
                if (isResponseWithError.booleanValue()) {
                    return Optional.of(RestError.CONNECTIVITY);
                }
                return Optional.empty();
            }
            return (Optional)super.httpResponseToErrorTypeDefinition().apply(httpResponse);
        };
    }

    protected <E extends Enum<E>> ModuleException createModuleException(HttpResponse httpResponse, ErrorTypeDefinition<E> errorTypeDefinition) {
        String description = this.getExpressionLanguage().evaluate("#[payload.description]", DataType.TEXT_STRING, BindingContext.builder().addBinding("payload", new TypedValue((Object)httpResponse.getEntity().getContent(), DataType.JSON_STRING)).build()).getValue().toString();
        return new ModuleException(description, errorTypeDefinition);
    }

    @MediaType(value="application/json")
    @Throws(value={RestErrorTypeProvider.class})
    public void addInvalidCategory(@Connection RestConnection connection, CompletionCallback<InputStream, Object> completionCallback, @TypeResolver(value=CategoryParameterAddInvalidCategoryOperationInputResolver.class) InputStream category) {
        try {
            String fullUri = connection.getBaseUri() + "/category/invalid";
            HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(fullUri).entity((HttpEntity)new InputStreamHttpEntity(category))).method(HttpConstants.Method.POST).build();
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)connection.sendAsync(request).thenApply(httpResponse -> {
                httpResponse = ((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().headers(httpResponse.getHeaders())).statusCode(Integer.valueOf(httpResponse.getStatusCode())).reasonPhrase(httpResponse.getReasonPhrase()).entity((HttpEntity)new ByteArrayHttpEntity(IOUtils.toByteArray((InputStream)httpResponse.getEntity().getContent())))).build();
                return httpResponse;
            })).thenApply(this.throwModuleExceptionIfErrorResponse())).thenAccept(httpResponse -> completionCallback.success(Result.builder().output((Object)httpResponse.getEntity().getContent()).build()))).exceptionally(this.notifyCompletionCallbackError(completionCallback));
        }
        catch (Throwable t) {
            completionCallback.error(t);
        }
    }
}

