/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cookBook.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public abstract class CookBookSignalErrorHandlingBaseOperation
extends BaseRestOperation {
    protected Function<HttpResponse, Optional<ErrorTypeDefinition<? extends Enum<?>>>> httpResponseToErrorTypeDefinition() {
        return httpResponse -> {
            if (httpResponse.getStatusCode() >= 200 && httpResponse.getStatusCode() < 300) {
                Boolean isResponseWithError = (Boolean)this.getExpressionLanguage().evaluate("#[payload.error]", DataType.fromType(Boolean.class), BindingContext.builder().addBinding("payload", new TypedValue((Object)httpResponse.getEntity().getContent(), DataType.JSON_STRING)).build()).getValue();
                if (isResponseWithError.booleanValue()) {
                    return Optional.of(RestError.CONNECTIVITY);
                }
                return Optional.empty();
            }
            return (Optional)super.httpResponseToErrorTypeDefinition().apply(httpResponse);
        };
    }

    protected <E extends Enum<E>> ModuleException createModuleException(HttpResponse httpResponse, ErrorTypeDefinition<E> errorTypeDefinition) {
        String description = this.getExpressionLanguage().evaluate("#[payload.description]", DataType.TEXT_STRING, BindingContext.builder().addBinding("payload", new TypedValue((Object)httpResponse.getEntity().getContent(), DataType.JSON_STRING)).build()).getValue().toString();
        return new ModuleException(description, errorTypeDefinition);
    }
}

