/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cookBook.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.internal.util.AutoCloseableCursorProviderInputStream;
import com.mulesoft.connectivity.rest.commons.internal.util.FileUtils;
import com.mulesoft.connectors.cookBook.internal.metadata.GetIngredientsByIdOperationOutputResolver;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

public class GetIngredientByIdOperation
extends BaseRestOperation
implements Initialisable {
    private String getIngredientOutputTransformationFile;

    public void initialise() {
        this.getIngredientOutputTransformationFile = FileUtils.readFile((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"cookBook/dw/GetIngredientOutputTransformation.dwl");
    }

    @MediaType(value="application/json")
    @Throws(value={RestErrorTypeProvider.class})
    @OutputResolver(output=GetIngredientsByIdOperationOutputResolver.class)
    public void getIngredientById(@Connection RestConnection connection, int idIngredient, CompletionCallback<InputStream, Object> completionCallback) {
        try {
            String fullUri = String.format(connection.getBaseUri() + "/ingredient/%d", idIngredient);
            HttpRequest request = HttpRequest.builder().uri(fullUri).method(HttpConstants.Method.GET).build();
            ((CompletableFuture)((CompletableFuture)connection.sendAsync(request).thenApply(this.throwModuleExceptionIfErrorResponse())).thenAccept(httpResponse -> {
                InputStream content = httpResponse.getEntity().getContent();
                TypedValue tvInput = new TypedValue((Object)content, DataType.JSON_STRING);
                TypedValue typedValue = this.getExpressionLanguage().evaluate(this.getIngredientOutputTransformationFile, BindingContext.builder().addBinding("payload", tvInput).build());
                Result result = Result.builder().output((Object)new AutoCloseableCursorProviderInputStream((CursorStreamProvider)typedValue.getValue())).build();
                completionCallback.success(result);
            })).exceptionally(this.notifyCompletionCallbackError(completionCallback));
        }
        catch (Throwable t) {
            completionCallback.error(t);
        }
    }
}

