package com.mulesoft.connectors.cookBook.internal.connection.provider;

import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthState;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.connectivity.rest.commons.api.connection.oauth.BaseAuthorizationCodeConnectionProvider;
import com.mulesoft.connectivity.rest.commons.api.connection.oauth.OAuthRestConnection;

@Alias("oauth-authorization-code")
@AuthorizationCode(
    accessTokenUrl = "http://localhost:${freePortFound}/access-token",
    authorizationUrl = "http://localhost:${freePortFound}/authorize",
    defaultScopes = "READ")
public class CookBookOauthAuthorizationCodeConnectionProvider
    extends BaseAuthorizationCodeConnectionProvider<OAuthRestConnection<OAuthState>> {

  @DisplayName("Base Uri")
  @Summary("Parameter base URI. Each instance or tenant gets its own base URI.")
  @Parameter
  @Optional
  private String baseUri;

  @Override
  public String getBaseUri() {
    return baseUri;
  }

  @Override
  public ConnectionValidationResult validate(OAuthRestConnection<OAuthState> restConnection) {
    return restConnection.validate(HttpRequest.builder()
        .uri(restConnection.getBaseUri() + "/health")
        .method(HttpConstants.Method.GET)
        .build(), httpResponse -> {
          int statusCode = httpResponse.getStatusCode();

          if (statusCode > 300 || statusCode < 200) {
            return ConnectionValidationResult.failure("Invalid status code: " + statusCode,
                                                      new Exception("Invalid status code: " + statusCode));
          } else {
            return ConnectionValidationResult.success();
          }
        }, exception -> ConnectionValidationResult.failure("There was an error while testing the connection", exception));
  }
}
