package com.mulesoft.connectors.cookBook.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectors.cookBook.internal.metadata.CategoryParameterAddInvalidCategoryOperationInputResolver;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import java.io.InputStream;
import java.util.Optional;
import java.util.function.Function;

import static java.util.Optional.of;
import static org.mule.sdk.api.annotation.param.MediaType.APPLICATION_JSON;

public class AddInvalidCategorySignalErrorHandlingOperation extends CookBookSignalErrorHandlingBaseOperation {

  @MediaType(APPLICATION_JSON)
  // Default mule error types
  @Throws(RestErrorTypeProvider.class)
  public void addInvalidCategorySignalErrorHandling(
                                                    @Connection RestConnection connection,
                                                    CompletionCallback<InputStream, Object> completionCallback,
                                                    @TypeResolver(CategoryParameterAddInvalidCategoryOperationInputResolver.class) InputStream category) {
    try {
      // Build the endpoint full uri. Example http://devkit-cookbook.cloudhub.io/rest/category
      String fullUri = connection.getBaseUri() + "/category/invalid";

      // Build the http request using HttpRequestBuilder
      HttpRequest request = HttpRequest.builder()
          .uri(fullUri)
          .entity(new InputStreamHttpEntity(category))
          .method(HttpConstants.Method.POST)
          .build();

      // Do sendAsync
      connection.sendAsync(request)
          // If http status code error present, throw error. Example, the SaaS returns a status code 404
          // but a override method for createModuleException is added to change the response message
          .thenApply(throwModuleExceptionIfErrorResponse())
          // Set the callback in success with a Result object with the whole content returned by SaaS
          .thenAccept(httpResponse -> completionCallback.success(Result
              .<InputStream, Object>builder()
              .output(httpResponse.getEntity().getContent())
              .build()))
          // Set the callback in error if the sendAsync CompletableFuture finished exceptionally
          .exceptionally(notifyCompletionCallbackError(completionCallback));
    } catch (Throwable t) {
      // Set the callback in error if any Throwable exception occurred, include http status code error
      completionCallback.error(t);
    }
  }

}
