package com.mulesoft.connectors.cookBook.internal.operation;

import static org.mule.sdk.api.annotation.param.MediaType.APPLICATION_JSON;

import com.mulesoft.connectors.cookBook.internal.metadata.GetIngredientsByIdOperationOutputResolver;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.internal.util.AutoCloseableCursorProviderInputStream;
import com.mulesoft.connectivity.rest.commons.internal.util.FileUtils;

import java.io.InputStream;

public class GetIngredientByIdOperation extends BaseRestOperation implements Initialisable {

    private String getIngredientOutputTransformationFile;

    @Override
    public void initialise(){
        getIngredientOutputTransformationFile=FileUtils.readFile(getClass().getClassLoader(),
                           "cookBook/dw/GetIngredientOutputTransformation.dwl");
    }

  @MediaType(APPLICATION_JSON)
  // Default mule error types
  @Throws(RestErrorTypeProvider.class)
  // Define output resolver class
  @OutputResolver(
      output = GetIngredientsByIdOperationOutputResolver.class)
  public void getIngredientById(
                                @Connection RestConnection connection,
                                int idIngredient,
                                CompletionCallback<InputStream, Object> completionCallback) {
    try {
      // Build the endpoint full uri. Example http://devkit-cookbook.cloudhub.io/rest/ingredient
      String fullUri = String.format(connection.getBaseUri() + "/ingredient/%d", idIngredient);

      // Build the http request using HttpRequestBuilder
      HttpRequest request = HttpRequest.builder()
          .uri(fullUri)
          .method(HttpConstants.Method.GET)
          .build();

      // Do sendAsync
      connection.sendAsync(request)
          // If http status code error present, throw error. Example, the SaaS returns a status code 404
          .thenApply(throwModuleExceptionIfErrorResponse())
          // Set the callback in success with a Result object with the whole content returned by SaaS
          .thenAccept(httpResponse -> {
            // Transform response content using a dataweave expression
            InputStream content = httpResponse.getEntity().getContent();
            TypedValue<String> tvInput = new TypedValue(content, DataType.JSON_STRING);
            TypedValue<?> typedValue = getExpressionLanguage()
                .evaluate(
                    getIngredientOutputTransformationFile,
                          BindingContext.builder()
                              .addBinding("payload", tvInput)
                              .build());

            Result<InputStream, Object> result = Result
                .<InputStream, Object>builder()
                .output(new AutoCloseableCursorProviderInputStream((CursorStreamProvider) typedValue.getValue()))
                .build();
            completionCallback.success(result);
          })
          // Set the callback in error if the sendAsync CompletableFuture finished exceptionally
          .exceptionally(notifyCompletionCallbackError(completionCallback));
    } catch (Throwable t) {
      // Set the callback in error if any Throwable exception occurred, include http status code error
      completionCallback.error(t);
    }
  }
}
