/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package cookBook.server.authentication;

import static io.vertx.core.http.HttpHeaders.AUTHORIZATION;
import static org.apache.commons.lang3.StringUtils.isBlank;

import java.util.Base64;

import io.vertx.core.http.HttpServerRequest;

public class AuthenticationUtils {

  private AuthenticationUtils() {}

  public static final String IS_AUTHORIZED_VAR = "isAuthorized";

  public static boolean validateBasicAuthorizationHeader(HttpServerRequest request, String expectedUsername,
                                                         String expectedPassword) {
    String authorizationHeader = request.headers().get(AUTHORIZATION);

    if (isBlank(authorizationHeader) || !authorizationHeader.startsWith("Basic ")) {
      return false;
    }

    int idx = authorizationHeader.indexOf(' ');
    String authorizationString = authorizationHeader.substring(idx + 1);

    String decoded = new String(Base64.getDecoder().decode(authorizationString));
    int colonIdx = decoded.indexOf(":");

    if (colonIdx < 0) {
      return false;
    }

    String username = decoded.substring(0, colonIdx);
    String password = decoded.substring(colonIdx + 1);

    return username.equals(expectedUsername) && password.equals(expectedPassword);
  }
}
