/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package cookBook.server.authentication;

import static cookBook.server.authentication.AuthenticationUtils.validateBasicAuthorizationHeader;
import static cookBook.server.authentication.CheckUserIsAuthenticatedHandler.IS_AUTHORIZED_VAR;
import static io.vertx.core.http.HttpHeaders.AUTHORIZATION;
import static org.apache.commons.lang3.StringUtils.isBlank;

import java.util.Base64;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;

public class BasicAuthHandler implements Handler<RoutingContext> {

  public final static String EXPECTED_USERNAME = "username";
  public final static String EXPECTED_PASSWORD = "password";

  @Override
  public void handle(RoutingContext context) {
    if (validateBasicAuthorizationHeader(context.request(), EXPECTED_USERNAME, EXPECTED_PASSWORD)) {
      context.data().put(IS_AUTHORIZED_VAR, true);
    }

    context.next();
  }

}
