package cookBook.server.authentication;

import static io.vertx.core.http.HttpHeaders.AUTHORIZATION;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public class BearerAuthHandler implements Handler<RoutingContext> {

  private static final String IS_AUTHORIZED_VAR = "isAuthorized";
  private final static String EXPECTED_TOKEN =
      "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiaWF0IjoxNTE2MjM5MDIyfQ.SflKxwRJSMeKKF2QT4fwpMeJf36POk6yJV_adQssw5c";

  @Override
  public void handle(RoutingContext context) {
    String authorizationHeader = context.request().getHeader(AUTHORIZATION);

    if (isNotBlank(authorizationHeader) && authorizationHeader.equals("Bearer " + EXPECTED_TOKEN)) {
      context.data().put(IS_AUTHORIZED_VAR, true);
    }
    context.next();
  }
}
