package cookBook.server.authentication;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public class CheckUserIsAuthenticatedHandler implements Handler<RoutingContext> {

  public static final String IS_AUTHORIZED_VAR = "isAuthorized";

  @Override
  public void handle(RoutingContext context) {
    if (context.data().containsKey(IS_AUTHORIZED_VAR)) {
      boolean isAuthorized = (boolean) context.data().get(IS_AUTHORIZED_VAR);

      if (isAuthorized) {
        context.next();
        return;
      }
    }

    context.response().setStatusCode(403).end("Unauthorized");
  }
}
