package cookBook.server.operation;


import static java.lang.String.format;

import org.mule.runtime.core.api.util.IOUtils;

import java.util.List;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public class GetAllRecipesHypermediaBodyPagination implements Handler<RoutingContext> {

  public GetAllRecipesHypermediaBodyPagination() {}

  @Override
  public void handle(RoutingContext context) {
    List<String> page = context.queryParam("page");
    context.response()
        .setStatusCode(200)
        .putHeader("Content-Type", "application/json")
        .end(IOUtils.toString(getClass()
                .getResourceAsStream(format("/server/hypermedia/hypermedia-body-paging-response-%s.json", page.isEmpty() ? "1" : page.get(0)))));
  }

}
