package cookBook.server.operation;


import static java.lang.Integer.parseInt;
import static java.lang.String.format;

import org.mule.runtime.core.api.util.IOUtils;

import java.util.List;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public class GetAllRecipesHypermediaHeaderPagination implements Handler<RoutingContext> {

  public GetAllRecipesHypermediaHeaderPagination() {}

  @Override
  public void handle(RoutingContext context) {
    List<String> page = context.queryParam("page");
    int pageNumber = page.isEmpty() ? 1 : parseInt(page.get(0));
    if (pageNumber < 3) {
      context.response().putHeader("link", format("</recipes-hypermedia-header?page=%s>; rel=\"next\", </recipes-hypermedia-header?page=3>; rel=\"last\"",
              pageNumber + 1));
    }
    context.response()
        .setStatusCode(200)
        .putHeader("Content-Type", "application/json")
        .end(IOUtils.toString(getClass()
                .getResourceAsStream(format("/server/hypermedia/hypermedia-header-paging-response-%s.json", pageNumber))));
  }

}
