package cookBook.server.operation;


import static java.lang.String.format;

import org.mule.runtime.core.api.util.IOUtils;

import java.util.List;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public class GetAllRecipesMarkerPagination implements Handler<RoutingContext> {

  public GetAllRecipesMarkerPagination() {}

  @Override
  public void handle(RoutingContext context) {
    List<String> marker = context.queryParam("marker");
    context.response()
        .setStatusCode(200)
        .putHeader("Content-Type", "application/json")
        .end(IOUtils.toString(getClass()
                .getResourceAsStream(format("/server/marker/marker-paging-response-%s.json", marker.isEmpty() ? "1" : marker.get(0)))));
  }

}
