package cookBook.server.operation;


import static java.lang.String.format;

import org.mule.runtime.core.api.util.IOUtils;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public class GetAllRecipesOffsetPagination implements Handler<RoutingContext> {

  public GetAllRecipesOffsetPagination() {}

  @Override
  public void handle(RoutingContext context) {
    String offset = context.queryParam("offset").get(0);
    int page = (Integer.parseInt(offset) / 3) + 1;
    context.response()
        .setStatusCode(200)
        .putHeader("Content-Type", "application/json")
        .end(IOUtils.toString(getClass()
                .getResourceAsStream(format("/server/offset/offset-paging-response-%s.json", page))));
  }

}
