package cookBook.server.operation;


import static java.lang.Integer.parseInt;
import static java.lang.String.format;

import org.mule.runtime.core.api.util.IOUtils;

import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public class GetAllRecipesPageNumberPagination implements Handler<RoutingContext> {

  public GetAllRecipesPageNumberPagination() {}

  @Override
  public void handle(RoutingContext context) {
    int pageNumber = parseInt(context.queryParam("page_number").get(0));

    context.response()
        .setStatusCode(200)
        .putHeader("Content-Type", "application/json")
        .end(IOUtils.toString(getClass()
                .getResourceAsStream(format("/server/page-number/page-number-paging-response-%s.json", pageNumber))));
  }

}
