/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package cookBook.server.operation;

import static org.apache.commons.lang3.StringUtils.isNotBlank;

import com.google.gson.Gson;
import cookBook.server.model.Category;
import cookBook.server.model.Ingredient;
import cookBook.server.model.Recipe;
import io.vertx.ext.web.RoutingContext;
import org.apache.commons.lang3.StringUtils;

public class OperationUtil {

  public static boolean validateIngredient(RoutingContext context) {
    Gson gson = new Gson();
    String json = context.getBodyAsString();

    if (StringUtils.isBlank(json)) {
      context.response().setStatusCode(400).end("Request body is empty");
      return false;
    }

    Ingredient ingredient;
    try {
      ingredient = gson.fromJson(json, Ingredient.class);
    } catch (Exception e) {
      context.response().setStatusCode(400).end("Could not parse request body");
      return false;
    }

    boolean valid = isNotBlank(ingredient.getName()) && ingredient.getQuantity() != 0 && ingredient.getUnit() != null;

    if (!valid) {
      context.response().setStatusCode(400).end("Required properties are not present in the request body");
      return false;
    }

    return true;
  }

  public static boolean validateRecipe(RoutingContext context) {
    Gson gson = new Gson();
    String json = context.getBodyAsString();

    if (StringUtils.isBlank(json)) {
      context.response().setStatusCode(400).end("Request body is empty");
      return false;
    }

    Recipe recipe;
    try {
      recipe = gson.fromJson(json, Recipe.class);
    } catch (Exception e) {
      context.response().setStatusCode(400).end("Could not parse request body");
      return false;
    }

    boolean valid = isNotBlank(recipe.getName())
        && recipe.getCookTime() != null
        && recipe.getPrepTime() != null
        && !recipe.getIngredients().isEmpty()
        && !recipe.getDirections().isEmpty();

    if (!valid) {
      context.response().setStatusCode(400).end("Required properties are not present in the request body");
      return false;
    }

    return true;
  }

  public static boolean validateCategory(RoutingContext context) {
    Gson gson = new Gson();
    String json = context.getBodyAsString();

    if (StringUtils.isBlank(json)) {
      context.response().setStatusCode(400).end("Request body is empty");
      return false;
    }

    Category category;
    try {
      category = gson.fromJson(json, Category.class);
    } catch (Exception e) {
      context.response().setStatusCode(400).end("Could not parse request body");
      return false;
    }

    boolean valid = isNotBlank(category.getName()) && category.getIdentifier() != null && category.getDescription() != null;

    if (!valid) {
      context.response().setStatusCode(400).end("Required properties are not present in the request body");
      return false;
    }

    return true;
  }

}
