package cookBook.server.operation;


import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public class PostCategory implements Handler<RoutingContext> {

  public PostCategory() {}

  @Override
  public void handle(RoutingContext context) {
    if (!OperationUtil.validateCategory(context)) {
      return;
    }

    context.response()
            .setStatusCode(200)
            .putHeader("Content-Type", "application/json")
            .end("{\n" +
                    "  \"identifier\":\"Vegan\",\n" +
                    "  \"name\":\"Vegan\",\n" +
                    "  \"description\":\"Category for vegan recipes\",\n" +
                    "  \"created\": \"2015-02-01 00:00:00\",\n" +
                    "  \"lastModified\":null\n" +
                    "}");
  }

}
