package cookBook.server.operation;


import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public class PostIngredient implements Handler<RoutingContext> {

  public PostIngredient() {}

  @Override
  public void handle(RoutingContext context) {
    if (!OperationUtil.validateIngredient(context)) {
      return;
    }

    context.response()
        .setStatusCode(200)
        .putHeader("Content-Type", "application/json")
        .end("{\n" +
            "  \"id\":1,\n" +
            "  \"name\":\"Apple\",\n" +
            "  \"quantity\":1.0,\n" +
            "  \"unit\":\"UNIT\",\n" +
            "  \"created\": \"2015-02-01 00:00:00\",\n" +
            "  \"lastModified\":null\n" +
            "}");
  }

}
