package cookBook.server.operation;


import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;

public class PostRecipe implements Handler<RoutingContext> {

  public PostRecipe() {}

  @Override
  public void handle(RoutingContext context) {
    if (!OperationUtil.validateRecipe(context)) {
      return;
    }

    context.response()
        .setStatusCode(200)
        .putHeader("Content-Type", "application/json")
        .end("{\n" +
            "  \"id\": 3,\n" +
            "  \"cookTime\": 20.5,\n" +
            "  \"directions\": [\n" +
            "    \"Cut the Apples\",\n" +
            "    \"Put them in the oven\",\n" +
            "    \"Remove from the oven after 20.0 minutes\"\n" +
            "  ],\n" +
            "  \"ingredients\": [\n" +
            "    {\n" +
            "      \"quantity\": 1,\n" +
            "      \"unit\": \"UNIT\",\n" +
            "      \"created\": \"2015-02-01 00:00:00\",\n" +
            "      \"id\": 1,\n" +
            "      \"lastModified\": null,\n" +
            "      \"name\": \"Apple\"\n" +
            "    }\n" +
            "  ],\n" +
            "  \"prepTime\": 30.0,\n" +
            "  \"created\": \"2015-02-01 00:00:00\",\n" +
            "  \"lastModified\": null,\n" +
            "  \"name\": \"Baked Apples\"\n" +
            "}");
  }

}
