package com.mulesoft.connectors.cookBook.internal.connection;

import com.mulesoft.connectivity.rest.commons.api.connection.DefaultRestConnection;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import java.util.concurrent.CompletableFuture;

public class CookBookSignalErrorHandlingConnection extends DefaultRestConnection {

  public CookBookSignalErrorHandlingConnection(HttpClient httpClient, HttpRequestOptions httpRequestOptions, String baseUri) {
    super(httpClient, httpRequestOptions, baseUri);
  }

  @Override
  public CompletableFuture<HttpResponse> sendAsync(HttpRequest request) {
    return super.sendAsync(request).thenApply(httpResponse -> {
      httpResponse = HttpResponse.builder()
          .headers(httpResponse.getHeaders())
          .statusCode(httpResponse.getStatusCode())
          .reasonPhrase(httpResponse.getReasonPhrase())
          // Making the current http response repeatable
          .entity(new ByteArrayHttpEntity(IOUtils.toByteArray(httpResponse.getEntity().getContent())))
          .build();
      return httpResponse;
    });
  }

}
