package com.mulesoft.connectors.cookBook.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectors.cookBook.internal.metadata.CategoryParameterAddCategoryOperationInputResolver;
import com.mulesoft.connectors.cookBook.internal.metadata.AddCategoryOperationOutputResolver;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.InputStreamHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import java.io.InputStream;

import static org.mule.sdk.api.annotation.param.MediaType.APPLICATION_JSON;

public class AddCategoryOperation extends BaseRestOperation {

    @MediaType(APPLICATION_JSON)
    //Default mule error types
    @Throws(RestErrorTypeProvider.class)
    //Define output resolver class
    @OutputResolver(
        output = AddCategoryOperationOutputResolver.class)
    public void addCategory(
        @Connection RestConnection connection,
        CompletionCallback<InputStream, Object> completionCallback,
        @TypeResolver(CategoryParameterAddCategoryOperationInputResolver.class)
            InputStream category
    ) {
        try {
            //Build the endpoint full uri. Example http://devkit-cookbook.cloudhub.io/rest/category
            String fullUri = connection.getBaseUri() + "/category";

            //Build the http request using HttpRequestBuilder
            HttpRequest request = HttpRequest.builder()
                .uri(fullUri)
                .entity(new InputStreamHttpEntity(category))
                .method(HttpConstants.Method.POST)
                .build();

            //Do sendAsync
            connection.sendAsync(request)
                //If http status code error present, throw error. Example, the SaaS returns a status code 404
                //but a override method for createModuleException is added to change the response message
                .thenApply(throwModuleExceptionIfErrorResponse())
                //Set the callback in success with a Result object with the whole content returned by SaaS
                .thenAccept(httpResponse -> completionCallback.success(Result
                                                                           .<InputStream, Object>builder()
                                                                           .output(httpResponse.getEntity().getContent())
                                                                           .build()))
                //Set the callback in error if the sendAsync CompletableFuture finished exceptionally
                .exceptionally(notifyCompletionCallbackError(completionCallback));
        } catch (Throwable t) {
            //Set the callback in error if any Throwable exception occurred, include http status code error
            completionCallback.error(t);
        }
    }

}
