package com.mulesoft.connectors.cookBook.internal.operation;

import static org.mule.sdk.api.annotation.param.MediaType.APPLICATION_JSON;

import com.mulesoft.connectors.cookBook.internal.metadata.CloneRecipeOperationOutputResolver;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;

import java.io.InputStream;

public class CloneRecipeOperation extends BaseRestOperation {

  @MediaType(APPLICATION_JSON)
  // Default mule error types
  @Throws(RestErrorTypeProvider.class)
  // Define output resolver class
  @OutputResolver(
      output = CloneRecipeOperationOutputResolver.class)
  public void cloneRecipe(
                          @Connection RestConnection connection,
                          int idRecipeToBeCloned,
                          CompletionCallback<InputStream, Object> completionCallback) {
    try {
      // Build the endpoint full uri. Example http://devkit-cookbook.cloudhub.io/rest/recipe/10
      String fullUriFirstCall = String.format(connection.getBaseUri() + "/recipe/%d", idRecipeToBeCloned);

      // Build the http request using HttpRequestBuilder for first http call
      HttpRequest requestFirstCall = HttpRequest.builder()
          .uri(fullUriFirstCall)
          .method(HttpConstants.Method.GET)
          .build();

      // Do sendAsync
      connection.sendAsync(requestFirstCall)
          // If http status code error present, throw error. Example, the SaaS returns a status code 404
          .thenApply(throwModuleExceptionIfErrorResponse())
          // Add chained http call
          .thenCompose(httpResponse -> {
            // Build the endpoint full uri for second http call. Example http://devkit-cookbook.cloudhub.io/rest/recipe
            String fullUriSecondCall = connection.getBaseUri() + "/recipe";

            // Build the http request using HttpRequestBuilder for second http call
            HttpRequest requestSecondCall = HttpRequest.builder()
                .uri(fullUriSecondCall)
                .entity(httpResponse.getEntity())
                .method(HttpConstants.Method.POST)
                .build();

            return connection.sendAsync(requestSecondCall);
          })
          // It applies to second http call
          .thenApply(throwModuleExceptionIfErrorResponse())
          // Set the callback in success with a Result object with the whole content returned by SaaS by second http call
          .thenAccept(httpResponse -> completionCallback.success(Result
              .<InputStream, Object>builder()
              .output(httpResponse.getEntity().getContent())
              .build()))
          // Set the callback in error if the sendAsync CompletableFuture finished exceptionally
          .exceptionally(notifyCompletionCallbackError(completionCallback));
    } catch (Throwable t) {
      // Set the callback in error if any Throwable exception occurred, include http status code error
      completionCallback.error(t);
    }
  }

}
