package com.mulesoft.connectors.cookBook.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import java.util.Optional;
import java.util.function.Function;

import static java.util.Optional.of;
import static org.mule.runtime.api.metadata.DataType.fromType;

public abstract class CookBookSignalErrorHandlingBaseOperation extends BaseRestOperation {


  @Override
  protected Function<HttpResponse, Optional<ErrorTypeDefinition<? extends Enum<?>>>> httpResponseToErrorTypeDefinition() {
    return httpResponse -> {
      // Status code = 200
      if (httpResponse.getStatusCode() >= 200 && httpResponse.getStatusCode() < 300) {
        // Getting the error property from payload
        Boolean isResponseWithError = (Boolean) getExpressionLanguage()
            .evaluate("#[payload.error]",
                      fromType(Boolean.class),
                      BindingContext.builder()
                          .addBinding("payload", new TypedValue(httpResponse.getEntity().getContent(), DataType.JSON_STRING))
                          .build())
            .getValue();

        // If error property is true, return connectivity error, at the end, a custom module exception
        // could be returned
        if (isResponseWithError) {
          return of(RestError.CONNECTIVITY);
        } else {
          return Optional.empty();
        }
      }
      // Default behavior, it will be catched as a HTTP error
      return super.httpResponseToErrorTypeDefinition().apply(httpResponse);
    };
  }

  @Override
  protected <E extends Enum<E>> ModuleException createModuleException(HttpResponse httpResponse,
                                                                      ErrorTypeDefinition<E> errorTypeDefinition) {

    // Here a connectivity error was thrown before but the description field is needed in the response
    String description = (String) getExpressionLanguage()
        .evaluate("#[payload.description]",
                  DataType.TEXT_STRING,
                  BindingContext.builder()
                      .addBinding("payload", new TypedValue(httpResponse.getEntity().getContent(), DataType.JSON_STRING))
                      .build())
        .getValue().toString();

    return new ModuleException(description, errorTypeDefinition);
  }


}
