package com.mulesoft.connectors.cookBook.internal.operation;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.connectivity.rest.commons.api.config.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingDataWeaveProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy.PageNumberPagingStrategy;

public class GetAllRecipesPageNumberPaginationOperation extends BaseRestOperation {

  @Throws(RestErrorTypeProvider.class)
  public PagingProvider<RestConnection, TypedValue<String>> getAllRecipesPageNumberPagination(
          @Config RestConfiguration configuration) {

    return new RestPagingDataWeaveProvider<>(
            restConnection -> HttpRequest.builder()
                    .uri(restConnection.getBaseUri() + "/recipes-page-number"),
            resolveDefaultResponseMediaType(configuration),
            new PageNumberPagingStrategy("page_number", 1),
            getExpressionLanguage(),
            "payload.data");

  }
}
