package com.mulesoft.connectors.cookBook.internal.connection.provider;

import com.mulesoft.connectivity.rest.commons.api.connection.DefaultRestConnection;
import com.mulesoft.connectivity.rest.commons.api.connection.basic.BasicAuthenticationConnectionProvider;
import com.mulesoft.connectors.cookBook.internal.connection.CookBookSignalErrorHandlingConnection;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

@Alias("basic-signal")
public class CookBookSignalErrorHandlingBasicConnectionProvider extends BasicAuthenticationConnectionProvider {

  @DisplayName("Base Uri")
  @Summary("Parameter base URI. Each instance or tenant gets its own base URI.")
  @Parameter
  @Optional
  private String baseUri;

  @Override
  public String getBaseUri() {
    return baseUri;
  }

  @Override
  public ConnectionValidationResult validate(DefaultRestConnection defaultRestConnection) {
    return defaultRestConnection.validate(HttpRequest.builder()
        .uri(defaultRestConnection.getBaseUri() + "/health")
        .method(HttpConstants.Method.GET)
        .build(), httpResponse -> {
          int statusCode = httpResponse.getStatusCode();

          if (statusCode > 300 || statusCode < 200) {
            return ConnectionValidationResult.failure("Invalid status code: " + statusCode,
                                                      new Exception("Invalid status code: " + statusCode));
          } else {
            return ConnectionValidationResult.success();
          }
        }, exception -> ConnectionValidationResult.failure("There was an error while testing the connection", exception));
  }

  // Overrides the createConnection method returning the new connection that includes the new sendAsync method repeatable
  @Override
  protected CookBookSignalErrorHandlingConnection createConnection(HttpClient httpClient, HttpRequestOptions httpRequestOptions) {
    return new CookBookSignalErrorHandlingConnection(httpClient, httpRequestOptions, getBaseUri());
  }
}
