package com.mulesoft.connectors.cookBook.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public abstract class CookBookBaseErrorHandlingOperation extends BaseRestOperation {


  @Override
  protected <E extends Enum<E>> ModuleException createModuleException(HttpResponse httpResponse,
                                                                      ErrorTypeDefinition<E> errorTypeDefinition) {

    // Overriding default response provided when http status code error appears showing
    // for example "404 Not Found" for new module exception with transformation
    String description = (String) getExpressionLanguage()
        .evaluate("#[payload.description]",
                  DataType.TEXT_STRING,
                  BindingContext.builder()
                      .addBinding("payload", new TypedValue(httpResponse.getEntity().getContent(), DataType.JSON_STRING))
                      .build())
        .getValue().toString();

    return new ModuleException(httpResponse.getStatusCode() + " " + httpResponse.getReasonPhrase()
        + " - " + description, errorTypeDefinition);
  }


}
