package com.mulesoft.connectors.cookBook.internal.operation;

import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import java.io.InputStream;

import static org.mule.sdk.api.annotation.param.MediaType.APPLICATION_JSON;

public class GetInvalidRecipesByCategoryIdErrorHandlingOperation extends CookBookBaseErrorHandlingOperation {

  @MediaType(APPLICATION_JSON)
  // Default mule error types
  @Throws(RestErrorTypeProvider.class)
  public void getInvalidRecipesByCategoryIdErrorHandling(
                                                         @Connection RestConnection connection,
                                                         int idCategory,
                                                         CompletionCallback<InputStream, Object> completionCallback) {
    try {
      // Build the endpoint full uri. Example http://devkit-cookbook.cloudhub.io/rest/category/101/recipes
      String fullUri = String.format(connection.getBaseUri() + "/category/%d/recipes", idCategory);

      // Build the http request using HttpRequestBuilder
      HttpRequest request = HttpRequest.builder()
          .uri(fullUri)
          .method(HttpConstants.Method.GET)
          .build();

      // Do sendAsync
      connection.sendAsync(request)
          // If http status code error present, throw error. Example, the SaaS returns a status code 404
          // but a override method for createModuleException is added to change the response message
          .thenApply(throwModuleExceptionIfErrorResponse())
          // Set the callback in success with a Result object with the whole content returned by SaaS
          .thenAccept(httpResponse -> completionCallback.success(Result
              .<InputStream, Object>builder()
              .output(httpResponse.getEntity().getContent())
              .build()))
          // Set the callback in error if the sendAsync CompletableFuture finished exceptionally
          .exceptionally(notifyCompletionCallbackError(completionCallback));
    } catch (Throwable t) {
      // Set the callback in error if any Throwable exception occurred, include http status code error
      completionCallback.error(t);
    }
  }

}
