package com.mulesoft.connectors.cookBook.internal.connection;

import static org.mule.runtime.api.i18n.I18nMessageFactory.createStaticMessage;

import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

import com.mulesoft.connectivity.rest.commons.api.connection.DefaultRestConnection;
import com.mulesoft.connectivity.rest.commons.api.dw.CommonsBindingContext;
import com.mulesoft.connectivity.rest.commons.api.error.RestError;
import com.mulesoft.connectors.cookBook.internal.error.CookBookException;

public class CookBookCustomErrorMessageConnection extends DefaultRestConnection {

  public CookBookCustomErrorMessageConnection(HttpClient httpClient, HttpRequestOptions httpRequestOptions, String baseUri,
                                              ExpressionLanguage expressionLanguage) {
    super(httpClient, httpRequestOptions, baseUri, expressionLanguage);
  }

  @Override
  protected ModuleException createModuleException(HttpResponse httpResponse,
                                                  ErrorTypeDefinition<RestError> errorTypeDefinition,
                                                  MediaType mediaType) {

    // Here a connectivity error was thrown before but the description field is needed in the response
    String description = getCommonsExpressionLanguage()
            .evaluateAsJavaString("#[payload.description]",
                  CommonsBindingContext.builder()
                      .addJson("payload", httpResponse.getEntity().getContent(),
                               mediaType.getCharset().orElseThrow(() -> new MuleRuntimeException(
                                   createStaticMessage("mediaType doesn't have a charset definition"))))
                      .build());

    return new CookBookException(httpResponse.getStatusCode() + " " + httpResponse.getReasonPhrase()
                                   + " - " + description, errorTypeDefinition);
  }

}
