package com.mulesoft.connectors.cookBook.internal.operation;

import static com.mulesoft.connectivity.rest.commons.internal.util.FileUtils.readFile;
import static org.mule.runtime.extension.api.annotation.param.MediaType.APPLICATION_JSON;

import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.connectivity.rest.commons.api.config.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.dw.CommonsBindingContext;
import com.mulesoft.connectivity.rest.commons.api.dw.CommonsExpressionLanguageValue;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectors.cookBook.internal.metadata.AddIngredientOperationOutputResolver;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class AddIngredientOperation extends BaseRestOperation implements Initialisable {

  private String addIngredientInputTransformationFile;

  @Override
  public void initialise() {
    addIngredientInputTransformationFile = readFile(getClass().getClassLoader(),
                                                         "cookBook/dw/AddIngredientInputTransformation.dwl");
  }

  @MediaType(APPLICATION_JSON)
  // Default mule error types
  @Throws(RestErrorTypeProvider.class)
  // Define output resolver class
  @OutputResolver(
      output = AddIngredientOperationOutputResolver.class)
  public void addIngredient(
                            @Config RestConfiguration configuration,
                            @Connection RestConnection connection,
                            String name,
                            Double quantity,
                            String unit,
                            CompletionCallback<InputStream, Object> completionCallback) {
    try {
      // Build the endpoint full uri. Example http://devkit-cookbook.cloudhub.io/rest/ingredient
      String fullUri = connection.getBaseUri() + "/ingredient";

      // Build the body to be sent
      CommonsBindingContext requestBindingContext = CommonsBindingContext.builder()
          .addJava("name", name)
          .addJava("quantity", quantity)
          .addJava("unit", unit)
          .build();
      CommonsExpressionLanguageValue expressionLanguageResult = getCommonsExpressionLanguage().evaluateJson(
          addIngredientInputTransformationFile,
          requestBindingContext);

      // Build the http request using HttpRequestBuilder
      HttpRequest request = HttpRequest.builder()
          .uri(fullUri)
          .method(HttpConstants.Method.POST)
          // Adding the body to the request
          .entity(new ByteArrayHttpEntity(expressionLanguageResult.asByteArray(StandardCharsets.UTF_8)))
          .build();

      // Do sendAsync
      connection.sendAsync(request, resolveDefaultResponseMediaType(configuration))
          // Set the callback in success with a Result object with the whole content returned by SaaS
          .thenAccept(result -> completionCallback.success(Result
              .<InputStream, Object>builder()
              .output(result.getEntityContent())
              .mediaType(result.getMediaType())
              .build()))
          // Set the callback in error if the sendAsync CompletableFuture finished exceptionally
          .exceptionally(notifyCompletionCallbackError(completionCallback));
    } catch (Throwable t) {
      // Set the callback in error if any Throwable exception occurred, include http status code error
      completionCallback.error(t);
    }
  }
}
