package com.mulesoft.connectors.cookBook.internal.operation;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.connectivity.rest.commons.api.config.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.RestPagingDataWeaveProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.paging.strategy.DataweaveHypermediaPagingStrategy;

public class GetAllRecipesHypermediaBodyPaginationOperation extends BaseRestOperation {

  @Throws(RestErrorTypeProvider.class)
  public PagingProvider<RestConnection, TypedValue<String>> getAllRecipesHypermediaBodyPagination(
          @Config RestConfiguration configuration) {

    return new RestPagingDataWeaveProvider<>(
            restConnection -> HttpRequest.builder()
                    .uri(restConnection.getBaseUri() + "/recipes-hypermedia-body"),
            resolveDefaultResponseMediaType(configuration),
            new DataweaveHypermediaPagingStrategy("#[payload.nextUrl]", getExpressionLanguage()),
            getExpressionLanguage(),
            "payload.data");

  }
}
