package com.mulesoft.connectors.cookBook.internal.operation;

import static org.mule.runtime.extension.api.annotation.param.MediaType.APPLICATION_JSON;

import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import com.mulesoft.connectivity.rest.commons.api.config.RestConfiguration;
import com.mulesoft.connectivity.rest.commons.api.connection.RestConnection;
import com.mulesoft.connectivity.rest.commons.api.error.RestErrorTypeProvider;
import com.mulesoft.connectivity.rest.commons.api.operation.BaseRestOperation;
import com.mulesoft.connectors.cookBook.internal.metadata.GetRecipeByIdOperationOutputResolver;

import java.io.InputStream;

public class GetRecipeByIdOperation extends BaseRestOperation {

  @MediaType(APPLICATION_JSON)
  // Default mule error types
  @Throws(RestErrorTypeProvider.class)
  // Define output resolver class
  @OutputResolver(
      output = GetRecipeByIdOperationOutputResolver.class)
  public void getRecipeById(
                            @Config RestConfiguration configuration,
                            @Connection RestConnection connection,
                            int idRecipe,
                            CompletionCallback<InputStream, Object> completionCallback) {
    try {
      // Build the endpoint full uri. Example http://devkit-cookbook.cloudhub.io/rest/recipe
      String fullUri = String.format(connection.getBaseUri() + "/recipe/%d", idRecipe);

      // Build the http request using HttpRequestBuilder
      HttpRequest request = HttpRequest.builder()
          .uri(fullUri)
          .method(HttpConstants.Method.GET)
          .build();

      // Do sendAsync
      connection.sendAsync(request, resolveDefaultResponseMediaType(configuration))
          // Set the callback in success with a Result object with the whole content returned by SaaS
          .thenAccept(result -> completionCallback.success(Result
              .<InputStream, Object>builder()
              .output(result.getEntityContent())
              .mediaType(result.getMediaType())
              .build()))
          // Set the callback in error if the sendAsync CompletableFuture finished exceptionally
          .exceptionally(notifyCompletionCallbackError(completionCallback));
    } catch (Throwable t) {
      // Set the callback in error if any Throwable exception occurred, include http status code error
      completionCallback.error(t);
    }
  }
}
