package com.mulesoft.connectors.cookBook.internal.source;

import com.mulesoft.connectivity.rest.commons.api.connection.DefaultRestConnection;
import com.mulesoft.connectivity.rest.commons.api.source.DataWeaveBasedRestPollingSourceStrategy;
import com.mulesoft.connectivity.rest.commons.api.source.RestPollingSource;
import com.mulesoft.connectivity.rest.commons.api.source.RestPollingSourceStrategy;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import java.util.Optional;

import static org.mule.sdk.api.annotation.param.MediaType.APPLICATION_JSON;

@MediaType(APPLICATION_JSON)
public class GetRecipesCommentsTrigger extends RestPollingSource<DefaultRestConnection, String,Void> {

    private static final String ITEMS_EXPRESSION = "payload.comments";

    private static final String WATERMARK_EXPRESSION = "item.time";

    private static final String IDENTITY_EXPRESSION = "item.idComment";

    private static final String ITEM_BINDING_NAME = "item";

    @Override protected RestPollingSourceStrategy<String, Void> getRestPollingSourceStrategy() throws MuleException {
        return new DataWeaveBasedRestPollingSourceStrategy(ITEMS_EXPRESSION, IDENTITY_EXPRESSION, WATERMARK_EXPRESSION,
                                                           ITEM_BINDING_NAME, this.getExpressionLanguage(), String.class);
    }

    @Override protected HttpRequest getRequest(Optional<String> lastWatermark) {
        return HttpRequest.builder()
            .method(HttpConstants.Method.GET)
            .uri(connection.getBaseUri() + "/recipes/comments")
            .build();
    }
}
