package com.mulesoft.connectors.cookBook.internal.source;

import com.mulesoft.connectivity.rest.commons.api.connection.DefaultRestConnection;
import com.mulesoft.connectivity.rest.commons.api.source.BaseDataWeaveBasedRestPollingSourceStrategy;
import com.mulesoft.connectivity.rest.commons.api.source.RestPollingSource;
import com.mulesoft.connectivity.rest.commons.api.source.RestPollingSourceStrategy;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;

import java.util.Optional;

import static org.mule.sdk.api.annotation.param.MediaType.APPLICATION_JSON;

@MediaType(APPLICATION_JSON)
public class GetRecipesCommentsWithAttributesTrigger extends RestPollingSource<DefaultRestConnection, String, MultiMap<String,Object>> {

    private static final String ITEMS_EXPRESSION = "payload.comments";

    private static final String WATERMARK_EXPRESSION = "item.time";

    private static final String IDENTITY_EXPRESSION = "item.idComment";

    private static final String ITEM_BINDING_NAME = "item";

    @Override protected RestPollingSourceStrategy<String, MultiMap<String,Object>> getRestPollingSourceStrategy() throws MuleException {
        return new BaseDataWeaveBasedRestPollingSourceStrategy<String, MultiMap<String,Object>>
            (ITEMS_EXPRESSION, IDENTITY_EXPRESSION,
            WATERMARK_EXPRESSION,ITEM_BINDING_NAME, this.getExpressionLanguage(),String.class) {

            @Override
            public MultiMap<String,Object> getItemAttributes(int statusCode, String reasonPhrase, MultiMap<String, String> headers,
                                                    TypedValue<String> item) {
                return new MultiMap<String,Object>(){{
                    put("Status Code",statusCode);
                    put("Reason Phrase",reasonPhrase);
                    put("Headers",headers);
                }};
            }
        };
    }

    @Override protected HttpRequest getRequest(Optional<String> lastWatermark) {
        return HttpRequest.builder()
            .method(HttpConstants.Method.GET)
            .uri(connection.getBaseUri() + "/recipes/comments")
            .build();
    }
}
