/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.extension.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Allows to reference a list of classes from which a {@code org.mule.extension.introspection.Configuration}
 * model is to be inferred. This annotation is to be used in classes which are also annotated with
 * {@link Extension} and {@link #value()} must reference classes which are annotated with {@link Configuration}
 *
 * @since 1.0
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface Configurations
{

    /**
     * @return An array of classes annotated with {@link Configuration}
     */
    Class<?>[] value();
}
