/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

public final class DefaultImplementationTypeAdapterFactory<SuperClass, ImplementationClass extends SuperClass>
implements TypeAdapterFactory {
    private final Class<ImplementationClass> clazz;
    private final Class<SuperClass> superClass;

    public DefaultImplementationTypeAdapterFactory(Class<SuperClass> superClass, Class<ImplementationClass> clazz) {
        if (!superClass.isAssignableFrom(clazz)) {
            throw new RuntimeException(String.format("[%s] class doesn't extends or implements [%s]", clazz, superClass));
        }
        this.clazz = clazz;
        this.superClass = superClass;
    }

    public <ImplementationClass> TypeAdapter<ImplementationClass> create(Gson gson, TypeToken<ImplementationClass> type) {
        if (this.superClass.isAssignableFrom(type.getRawType())) {
            return gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(this.clazz));
        }
        return null;
    }
}

