/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.extension.api.introspection.ModelProperty;
import org.mule.runtime.extension.api.persistence.ExtensionModelSerializationException;
import org.mule.runtime.extension.api.persistence.JsonSerializationConstants;

final class ModelPropertyMapTypeAdapter
extends TypeAdapter<Map<Class<? extends ModelProperty>, ModelProperty>> {
    private static final Map<Class<? extends ModelProperty>, String> classNameMapping = JsonSerializationConstants.getClassNameMapping();
    private static final Map<String, Class<? extends ModelProperty>> nameClassMapping = JsonSerializationConstants.getNameClassMapping();
    private final Gson gson;

    ModelPropertyMapTypeAdapter(Gson gson) {
        this.gson = gson;
    }

    public void write(JsonWriter out, Map<Class<? extends ModelProperty>, ModelProperty> modelPropertyMap) throws IOException {
        out.beginObject();
        for (Map.Entry<Class<? extends ModelProperty>, ModelProperty> entry : modelPropertyMap.entrySet()) {
            ModelProperty modelProperty = entry.getValue();
            Class<? extends ModelProperty> modelPropertyClass = entry.getKey();
            if (!modelProperty.isExternalizable()) continue;
            out.name(this.getSerializableModelPropertyName(modelPropertyClass));
            TypeAdapter adapter = this.gson.getAdapter(modelPropertyClass);
            adapter.write(out, (Object)modelProperty);
        }
        out.endObject();
    }

    public Map<Class<? extends ModelProperty>, ModelProperty> read(JsonReader in) throws IOException {
        HashMap<Class<? extends ModelProperty>, ModelProperty> modelPropertyHashMap = new HashMap<Class<? extends ModelProperty>, ModelProperty>();
        in.beginObject();
        while (in.hasNext()) {
            Optional<Class<? extends ModelProperty>> modelPropertyClass = this.getClassForModelProperty(in.nextName());
            if (!modelPropertyClass.isPresent()) continue;
            Class<? extends ModelProperty> type = modelPropertyClass.get();
            TypeAdapter adapter = this.gson.getAdapter(type);
            ModelProperty read = (ModelProperty)adapter.read(in);
            modelPropertyHashMap.put(type, read);
        }
        in.endObject();
        return modelPropertyHashMap;
    }

    private Optional<Class<? extends ModelProperty>> getClassForModelProperty(String modelPropertyName) {
        Class<Object> modelPropertyClass = null;
        if (nameClassMapping.containsKey(modelPropertyName)) {
            modelPropertyClass = nameClassMapping.get(modelPropertyName);
        } else {
            try {
                modelPropertyClass = Class.forName(modelPropertyName);
            }
            catch (ClassNotFoundException e) {
                throw new ExtensionModelSerializationException(String.format("Error loading [%s] ModelProperty. Class not found in the current classloader", modelPropertyName), e);
            }
        }
        return Optional.ofNullable(modelPropertyClass);
    }

    private String getSerializableModelPropertyName(Class<? extends ModelProperty> modelPropertyClass) {
        return classNameMapping.getOrDefault(modelPropertyClass, modelPropertyClass.getName());
    }
}

