/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence.metadata.dto;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.metadata.descriptor.ImmutableComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.OutputMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.internal.persistence.metadata.dto.Descriptable;
import org.mule.runtime.extension.internal.persistence.metadata.dto.Failure;
import org.mule.runtime.extension.internal.persistence.metadata.dto.OutputMetadata;
import org.mule.runtime.extension.internal.persistence.metadata.dto.ParameterMetadata;

public class ComponentMetadataResult
implements Descriptable<ImmutableComponentMetadataDescriptor> {
    static final String COMPONENT = "COMPONENT";
    private final String componentName;
    private final List<ParameterMetadata> parameters;
    private final OutputMetadata output;
    private final List<Failure> failures;

    public ComponentMetadataResult(MetadataResult<ImmutableComponentMetadataDescriptor> result) {
        this.componentName = ((ImmutableComponentMetadataDescriptor)result.get()).getName();
        this.output = new OutputMetadata((ImmutableComponentMetadataDescriptor)result.get());
        this.parameters = this.getParametersMetadata((ImmutableComponentMetadataDescriptor)result.get());
        this.failures = this.collectFailures(result);
    }

    private List<ParameterMetadata> getParametersMetadata(ImmutableComponentMetadataDescriptor componentResult) {
        ImmutableList.Builder parameterList = ImmutableList.builder();
        parameterList.addAll((Iterable)componentResult.getParametersMetadata().stream().map(p -> new ParameterMetadata(((ParameterMetadataDescriptor)p.get()).getName(), ((ParameterMetadataDescriptor)p.get()).getType(), false)).collect(Collectors.toList()));
        Optional contentMetadata = componentResult.getContentMetadata();
        if (contentMetadata.isPresent()) {
            ParameterMetadataDescriptor descriptor = (ParameterMetadataDescriptor)((MetadataResult)contentMetadata.get()).get();
            parameterList.add((Object)new ParameterMetadata(descriptor.getName(), descriptor.getType(), true));
        }
        return parameterList.build();
    }

    public MetadataResult<ImmutableComponentMetadataDescriptor> toComponentMetadataResult() {
        return this.toDescriptorResult(this.failures);
    }

    private List<Failure> collectFailures(MetadataResult<ImmutableComponentMetadataDescriptor> result) {
        ImmutableMap.Builder failures = ImmutableMap.builder();
        ImmutableComponentMetadataDescriptor descriptor = (ImmutableComponentMetadataDescriptor)result.get();
        if (result.isSuccess()) {
            return Collections.emptyList();
        }
        failures.put((Object)COMPONENT, result.getFailure().get());
        if (descriptor != null) {
            MetadataResult outputMetadata;
            Optional contentMetadata = descriptor.getContentMetadata();
            if (contentMetadata.isPresent() && !((MetadataResult)contentMetadata.get()).isSuccess()) {
                failures.put((Object)"CONTENT", ((MetadataResult)contentMetadata.get()).getFailure().get());
            }
            if (!(outputMetadata = descriptor.getOutputMetadata()).isSuccess()) {
                MetadataResult attributesMetadata;
                MetadataResult payloadMetadata = ((OutputMetadataDescriptor)outputMetadata.get()).getPayloadMetadata();
                if (!payloadMetadata.isSuccess()) {
                    failures.put((Object)"OUTPUT_PAYLOAD", payloadMetadata.getFailure().get());
                }
                if (!(attributesMetadata = ((OutputMetadataDescriptor)outputMetadata.get()).getAttributesMetadata()).isSuccess()) {
                    failures.put((Object)"OUTPUT_ATTRIBUTES", attributesMetadata.getFailure().get());
                }
                failures.put((Object)"OUTPUT", payloadMetadata.getFailure().get());
            }
        }
        return failures.build().entrySet().stream().map(e -> new Failure((MetadataFailure)e.getValue(), (String)e.getKey())).collect(Collectors.toList());
    }

    @Override
    public MetadataResult<ImmutableComponentMetadataDescriptor> toDescriptorResult(List<Failure> failures) {
        Optional<Failure> metadataFailure = this.getComponentFailure(failures, COMPONENT);
        Optional<ParameterMetadata> content = this.parameters.stream().filter(ParameterMetadata::isDynamic).findFirst();
        List parameterDescriptors = this.parameters.stream().filter(p -> !p.isDynamic()).map(p -> p.toDescriptorResult(failures)).collect(Collectors.toList());
        MetadataResult<ParameterMetadataDescriptor> contentResult = content.isPresent() ? content.get().toDescriptorResult(failures) : null;
        ImmutableComponentMetadataDescriptor descriptor = new ImmutableComponentMetadataDescriptor(this.componentName, parameterDescriptors, this.output.toDescriptorResult(failures), contentResult);
        if (metadataFailure.isPresent()) {
            return MetadataResult.failure((Object)descriptor, (String)metadataFailure.get().getMessage(), (FailureCode)metadataFailure.get().getFailureCode(), (String)metadataFailure.get().getReason());
        }
        return MetadataResult.success((Object)descriptor);
    }
}

