/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.persistence.metadata.dto;

import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.descriptor.ImmutableParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.descriptor.ParameterMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.extension.internal.persistence.metadata.dto.Descriptable;
import org.mule.runtime.extension.internal.persistence.metadata.dto.Failure;

class ParameterMetadata
implements Descriptable<ParameterMetadataDescriptor> {
    static final String CONTENT = "CONTENT";
    private final String name;
    private final MetadataType type;
    private final boolean isDynamic;

    ParameterMetadata(String name, MetadataType type, boolean isDynamic) {
        this.isDynamic = isDynamic;
        this.type = type;
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    MetadataType getType() {
        return this.type;
    }

    boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public MetadataResult<ParameterMetadataDescriptor> toDescriptorResult(List<Failure> failures) {
        Optional<Failure> metadataFailure = this.getComponentFailure(failures, this.isDynamic ? CONTENT : this.name);
        ImmutableParameterMetadataDescriptor descriptor = new ImmutableParameterMetadataDescriptor(this.name, this.type);
        if (metadataFailure.isPresent()) {
            return MetadataResult.failure((Object)descriptor, (String)metadataFailure.get().getMessage(), (FailureCode)metadataFailure.get().getFailureCode(), (String)metadataFailure.get().getReason());
        }
        return MetadataResult.success((Object)descriptor);
    }
}

