/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.DefaultObjectTypeReferenceHandler;
import org.mule.metadata.persistence.MetadataTypeGsonTypeAdapter;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.SerializationContext;
import org.mule.runtime.api.MuleVersion;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.ImmutableExtensionModel;
import org.mule.runtime.extension.api.introspection.ImmutableOutputModel;
import org.mule.runtime.extension.api.introspection.OutputModel;
import org.mule.runtime.extension.api.introspection.config.ConfigurationModel;
import org.mule.runtime.extension.api.introspection.config.ImmutableConfigurationModel;
import org.mule.runtime.extension.api.introspection.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.introspection.connection.ImmutableConnectionProviderModel;
import org.mule.runtime.extension.api.introspection.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.introspection.property.ImportedTypesModelProperty;
import org.mule.runtime.extension.api.introspection.property.SubTypesModelProperty;
import org.mule.runtime.extension.api.introspection.source.ImmutableSourceModel;
import org.mule.runtime.extension.api.introspection.source.SourceModel;
import org.mule.runtime.extension.api.persistence.DefaultImplementationTypeAdapterFactory;
import org.mule.runtime.extension.api.persistence.ExtensionModelTypeAdapter;
import org.mule.runtime.extension.api.persistence.ImportedTypesModelPropertyTypeAdapter;
import org.mule.runtime.extension.api.persistence.ModelPropertyMapTypeAdapterFactory;
import org.mule.runtime.extension.api.persistence.MuleVersionTypeAdapter;
import org.mule.runtime.extension.api.persistence.SubTypesModelPropertyTypeAdapter;

public class ExtensionModelJsonSerializer {
    private final boolean prettyPrint;

    public ExtensionModelJsonSerializer() {
        this(false);
    }

    public ExtensionModelJsonSerializer(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    private Gson buildGson() {
        final SerializationContext serializationContext = new SerializationContext();
        final Gson gsonDelegate = this.gsonBuilder(serializationContext, this.prettyPrint).create();
        return this.gsonBuilder(serializationContext, this.prettyPrint).registerTypeAdapterFactory(new TypeAdapterFactory(){

            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                if (ExtensionModel.class.isAssignableFrom(type.getRawType())) {
                    return new ExtensionModelTypeAdapter(gsonDelegate, serializationContext);
                }
                return null;
            }
        }).create();
    }

    private GsonBuilder gsonBuilder(SerializationContext serializationContext, boolean prettyPrint) {
        DefaultObjectTypeReferenceHandler referenceHandler = new DefaultObjectTypeReferenceHandler(serializationContext);
        DefaultImplementationTypeAdapterFactory<ConfigurationModel, ImmutableConfigurationModel> configurationModelTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<ConfigurationModel, ImmutableConfigurationModel>(ConfigurationModel.class, ImmutableConfigurationModel.class);
        DefaultImplementationTypeAdapterFactory<ConnectionProviderModel, ImmutableConnectionProviderModel> connectionProviderModelTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<ConnectionProviderModel, ImmutableConnectionProviderModel>(ConnectionProviderModel.class, ImmutableConnectionProviderModel.class);
        DefaultImplementationTypeAdapterFactory<OperationModel, ImmutableOperationModel> operationModelTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<OperationModel, ImmutableOperationModel>(OperationModel.class, ImmutableOperationModel.class);
        DefaultImplementationTypeAdapterFactory<SourceModel, ImmutableSourceModel> sourceModelTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<SourceModel, ImmutableSourceModel>(SourceModel.class, ImmutableSourceModel.class);
        DefaultImplementationTypeAdapterFactory<ParameterModel, ImmutableParameterModel> parameterModelTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<ParameterModel, ImmutableParameterModel>(ParameterModel.class, ImmutableParameterModel.class);
        DefaultImplementationTypeAdapterFactory<OutputModel, ImmutableOutputModel> outputModelTypeAdapterFactory = new DefaultImplementationTypeAdapterFactory<OutputModel, ImmutableOutputModel>(OutputModel.class, ImmutableOutputModel.class);
        ImportedTypesModelPropertyTypeAdapter importedTypesModelPropertyTypeAdapter = new ImportedTypesModelPropertyTypeAdapter((ObjectTypeReferenceHandler)referenceHandler);
        SubTypesModelPropertyTypeAdapter subTypesModelPropertyTypeAdapter = new SubTypesModelPropertyTypeAdapter((ObjectTypeReferenceHandler)referenceHandler);
        MuleVersionTypeAdapter muleVersionTypeAdapter = new MuleVersionTypeAdapter();
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(MetadataType.class, (Object)new MetadataTypeGsonTypeAdapter((ObjectTypeReferenceHandler)referenceHandler)).registerTypeAdapter(MuleVersion.class, (Object)muleVersionTypeAdapter).registerTypeAdapter(ImportedTypesModelProperty.class, (Object)importedTypesModelPropertyTypeAdapter).registerTypeAdapter(SubTypesModelProperty.class, (Object)subTypesModelPropertyTypeAdapter).registerTypeAdapterFactory((TypeAdapterFactory)new ModelPropertyMapTypeAdapterFactory()).registerTypeAdapterFactory(sourceModelTypeAdapterFactory).registerTypeAdapterFactory(parameterModelTypeAdapterFactory).registerTypeAdapterFactory(configurationModelTypeAdapterFactory).registerTypeAdapterFactory(connectionProviderModelTypeAdapterFactory).registerTypeAdapterFactory(operationModelTypeAdapterFactory).registerTypeAdapterFactory(outputModelTypeAdapterFactory);
        if (prettyPrint) {
            gsonBuilder.setPrettyPrinting();
        }
        return gsonBuilder;
    }

    public String serialize(ExtensionModel extensionModel) {
        return this.buildGson().toJson((Object)extensionModel);
    }

    public String serializeList(List<ExtensionModel> extensionModelList) {
        return this.buildGson().toJson(extensionModelList);
    }

    public ExtensionModel deserialize(String extensionModel) {
        return (ExtensionModel)this.buildGson().fromJson(extensionModel, ImmutableExtensionModel.class);
    }

    public List<ExtensionModel> deserializeList(String extensionModelList) {
        return (List)this.buildGson().fromJson(extensionModelList, new TypeToken<List<ImmutableExtensionModel>>(){}.getType());
    }
}

