/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.persistence;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;
import org.mule.metadata.persistence.JsonMetadataTypeWriter;
import org.mule.metadata.persistence.SerializationContext;
import org.mule.runtime.api.MuleVersion;
import org.mule.runtime.extension.api.Category;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.ImmutableExtensionModel;
import org.mule.runtime.extension.api.introspection.ModelProperty;
import org.mule.runtime.extension.api.introspection.config.ConfigurationModel;
import org.mule.runtime.extension.api.introspection.connection.ConnectionProviderModel;
import org.mule.runtime.extension.api.introspection.operation.OperationModel;
import org.mule.runtime.extension.api.introspection.source.SourceModel;
import org.mule.runtime.extension.internal.util.HierarchyClassMap;

class ExtensionModelTypeAdapter
extends TypeAdapter<ExtensionModel> {
    private static final String CONFIGURATIONS = "configurations";
    private static final String OPERATIONS = "operations";
    private static final String CONNECTION_PROVIDERS = "connectionProviders";
    private static final String MESSAGE_SOURCES = "messageSources";
    private static final String MODEL_PROPERTIES = "modelProperties";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String VERSION = "version";
    private static final String VENDOR = "vendor";
    private static final String CATEGORY = "category";
    private static final String TYPES = "types";
    private final Gson gsonDelegate;
    private final JsonMetadataTypeLoader typeLoader = new JsonMetadataTypeLoader();
    private final JsonMetadataTypeWriter typeWriter = new JsonMetadataTypeWriter();
    private final SerializationContext serializationContext;

    ExtensionModelTypeAdapter(Gson gsonDelegate, SerializationContext serializationContext) {
        this.gsonDelegate = gsonDelegate;
        this.serializationContext = serializationContext;
    }

    public void write(JsonWriter out, ExtensionModel model) throws IOException {
        out.beginObject();
        out.name(NAME).value(model.getName());
        out.name(DESCRIPTION).value(model.getDescription());
        out.name(VERSION).value(model.getVersion());
        out.name(VENDOR).value(model.getVendor());
        this.writeWithDelegate(model.getCategory(), CATEGORY, out, new TypeToken<Category>(){});
        out.name(VERSION).value(model.getVersion());
        this.writeWithDelegate(model.getConfigurationModels(), CONFIGURATIONS, out, new TypeToken<List<ConfigurationModel>>(){});
        this.writeWithDelegate(model.getOperationModels(), OPERATIONS, out, new TypeToken<List<OperationModel>>(){});
        this.writeWithDelegate(model.getConnectionProviders(), CONNECTION_PROVIDERS, out, new TypeToken<List<ConnectionProviderModel>>(){});
        this.writeWithDelegate(model.getSourceModels(), MESSAGE_SOURCES, out, new TypeToken<List<SourceModel>>(){});
        this.writeExtensionLevelModelProperties(out, model);
        this.writeTypes(out, model.getTypes());
        out.endObject();
    }

    public ExtensionModel read(JsonReader in) throws IOException {
        JsonObject json = new JsonParser().parse(in).getAsJsonObject();
        Set<ObjectType> types = this.parseTypes(json);
        List<ConfigurationModel> configs = this.parseWithDelegate(json, CONFIGURATIONS, new TypeToken<List<ConfigurationModel>>(){});
        List<OperationModel> operations = this.parseWithDelegate(json, OPERATIONS, new TypeToken<List<OperationModel>>(){});
        List<ConnectionProviderModel> providers = this.parseWithDelegate(json, CONNECTION_PROVIDERS, new TypeToken<List<ConnectionProviderModel>>(){});
        List<SourceModel> sources = this.parseWithDelegate(json, MESSAGE_SOURCES, new TypeToken<List<SourceModel>>(){});
        return new ImmutableExtensionModel(json.get(NAME).getAsString(), json.get(DESCRIPTION).getAsString(), json.get(VERSION).getAsString(), json.get(VENDOR).getAsString(), (Category)this.gsonDelegate.fromJson(json.get(CATEGORY), Category.class), (MuleVersion)this.gsonDelegate.fromJson(json.get(VERSION), MuleVersion.class), configs, operations, providers, sources, types, this.parseExtensionLevelModelProperties(json));
    }

    private <T> T parseWithDelegate(JsonObject json, String elementName, TypeToken<T> typeToken) {
        JsonElement element = json.get(elementName);
        if (element != null) {
            return (T)this.gsonDelegate.fromJson(element, typeToken.getType());
        }
        return null;
    }

    private <T> void writeWithDelegate(T value, String elementName, JsonWriter out, TypeToken<T> typeToken) throws IOException {
        out.name(elementName);
        this.gsonDelegate.toJson(value, typeToken.getType(), out);
    }

    private Set<ObjectType> parseTypes(JsonObject json) {
        HashSet<ObjectType> types = new HashSet<ObjectType>();
        JsonArray typesArray = json.get(TYPES).getAsJsonArray();
        if (typesArray == null) {
            return Collections.emptySet();
        }
        typesArray.forEach(typeElement -> this.typeLoader.load(typeElement).ifPresent(type -> {
            if (!(type instanceof ObjectType)) {
                throw new IllegalArgumentException(String.format("Was expecting an object type but %s was found instead", type.getClass().getSimpleName()));
            }
            ObjectType objectType = (ObjectType)type;
            this.serializationContext.registerObjectType(objectType);
            types.add(objectType);
        }));
        return types;
    }

    private void writeTypes(JsonWriter out, Set<ObjectType> additionalTypes) throws IOException {
        out.name(TYPES);
        out.beginArray();
        LinkedHashSet<ObjectType> objectTypes = new LinkedHashSet<ObjectType>();
        objectTypes.addAll(this.serializationContext.getRegisteredObjectTypes());
        objectTypes.addAll(additionalTypes);
        for (ObjectType type : objectTypes) {
            this.typeWriter.write((MetadataType)type, out);
        }
        out.endArray();
    }

    private void writeExtensionLevelModelProperties(JsonWriter out, ExtensionModel model) throws IOException {
        out.name(MODEL_PROPERTIES);
        HierarchyClassMap properties = new HierarchyClassMap();
        model.getModelProperties().forEach(p -> {
            ModelProperty cfr_ignored_0 = (ModelProperty)properties.put(p.getClass(), p);
        });
        this.gsonDelegate.toJson((Object)properties, new TypeToken<HierarchyClassMap<ModelProperty>>(){}.getType(), out);
    }

    private Set<ModelProperty> parseExtensionLevelModelProperties(JsonObject json) {
        HierarchyClassMap properties = (HierarchyClassMap)this.gsonDelegate.fromJson(json.get(MODEL_PROPERTIES), new TypeToken<HierarchyClassMap<ModelProperty>>(){}.getType());
        return properties.values().stream().collect(Collectors.toSet());
    }
}

